unit Trexdm02;

{
$Log:   W:/users/prodigy/prodig~1/archive/trex/trexdm02.pav  $
 * 
 *    Rev 1.1   07 Apr 1996 18:30:52   PaulK
 * Work in progress on demos
}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, StdCtrls, ExtCtrls, T_Rex, Gauges;

type
  TCounter = class(TObject)
    value: longint;
  constructor Create;
  procedure Increment;
  end;

type
  TForm1 = class(TForm)
    Rex1: TRex;
    OpenDialog1: TOpenDialog;
    Label1: TLabel;
    Bevel1: TBevel;
    Button1: TButton;
    Button2: TButton;
    BitBtn1: TBitBtn;
    Bevel2: TBevel;
    Label2: TLabel;
    Label3: TLabel;
    Gauge1: TGauge;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Rex1EOF(Sender: TObject);
    procedure Rex1BeforeLineMatch(Sender: TObject);
    procedure Rex1BOF(Sender: TObject);
    procedure Rex1Token(Sender: TObject; const Token: String);
  private
    { Private declarations }
    Wordlist: TStringList;
    Sortedlist: TStringList;
    WordPattern: TRegExp;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
if OpenDialog1.Execute then
  begin
  Rex1.FileSpec := OpenDialog1.Filename;
  Button2.Enabled := true;
  end
else
  Button2.Enabled := false;

end;

procedure TForm1.Button2Click(Sender: TObject);
begin
Screen.Cursor := crHourglass;
Rex1.Scan;
Screen.Cursor := crDefault;
end;

procedure TForm1.Rex1EOF(Sender: TObject);

var s: string; i: integer;

begin
Gauge1.Progress := Gauge1.MaxValue;
with WordList do
for i := 0 to pred(Count) do
  begin
  s := Format('%06d %s',[MaxInt-(Objects[i] as TCounter).value,Strings[i]]);
  SortedList.Add(s);
  end;

s := '';
for i := 0 to 9 do
  begin
  s := s + ' ' + copy(Sortedlist.Strings[i],8,255);
  if i > pred(SortedList.Count) then break;
  end;

With Rex1 do
  Label2.Caption :=
  Format('The commonest 10 words in %s are:%s.',
  [Filename,s]);

WordList.Free;
SortedList.Free;
WordPattern.Free;
end;

procedure TForm1.Rex1BeforeLineMatch(Sender: TObject);
begin
Label2.Caption := Format('Scanning %s  line %4d',[Rex1.Filename,Rex1.ScanLineNumber]);
Label2.Refresh;
Gauge1.Progress := Rex1.FilePosition;
end;

procedure TForm1.Rex1BOF(Sender: TObject);
begin
Gauge1.MaxValue := Rex1.Filesize;
WordList := TStringList.Create;
SortedList := TStringList.Create;
SortedList.Sorted := true;
WordPattern := TRegExp.Create('^[A-Za-z''-]+$');
end;

procedure TForm1.Rex1Token(Sender: TObject; const Token: String);

var
  i: Longint; s, l: word;

begin
if not WordPattern.Match(Token,s,l) then
  exit;
i := WordList.IndexOf(Token);
if i = -1 then {not in list}
  WordList.AddObject(Token,TCounter.Create)
else
  (WordList.Objects[i] as TCounter).Increment;
end;

constructor TCounter.Create;

begin
inherited Create;
value := 1;
end;

procedure TCounter.Increment;

begin
inc(value);
end;

end.
